/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.screen.animator.dialog;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import lib.toma.animations.IEasing;
import lib.toma.animations.engine.screen.animator.AnimationProject;
import lib.toma.animations.engine.screen.animator.Animator;
import lib.toma.animations.engine.screen.animator.AnimatorScreen;
import lib.toma.animations.engine.screen.animator.dialog.ChangeEasingDialog;
import lib.toma.animations.engine.screen.animator.dialog.DialogScreen;
import lib.toma.animations.engine.screen.animator.dialog.SuggestionResponder;
import lib.toma.animations.engine.screen.animator.widget.LabelWidget;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class SettingsDialog
extends DialogScreen {
    private final Pattern cyclePattern = Pattern.compile("[1-9][0-9]{0,2}");
    private TextFieldWidget cycleField;
    private CheckboxButton onRepeat;
    private Button easingButton;
    private boolean errored;

    public SettingsDialog(AnimatorScreen screen) {
        super((ITextComponent)new TranslationTextComponent("screen.animator.dialog.settings"), screen);
        this.setDimensions(135, 130);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        AnimationProject project = Animator.get().getProject();
        AnimationProject.AnimationController controller = project.getAnimationControl();
        this.func_230480_a_(new LabelWidget(this.left() + 5, this.top() + 15, this.dWidth() - 10, 15, (ITextComponent)new StringTextComponent("Animation cycle [ticks]"), this.field_230712_o_));
        this.cycleField = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.left() + 5, this.top() + 30, this.dWidth() - 10, 20, StringTextComponent.field_240750_d_));
        this.cycleField.func_212954_a((Consumer)new SuggestionResponder("Ticks", this.cycleField, this::cycleField_changed));
        this.cycleField.func_146180_a(String.valueOf(controller.getAnimationTime()));
        this.easingButton = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 55, this.dWidth() - 10, 20, controller.getEasing().getDisplayText(), this::setDefaultEasing_Clicked));
        this.onRepeat = (CheckboxButton)this.func_230480_a_((Widget)new CheckboxButton(this.left() + 5, this.top() + 80, this.dWidth() - 10, 20, (ITextComponent)new StringTextComponent("On repeat"), controller.isOnRepeat()));
        int btnWidthP = this.dWidth() - 10;
        int btnWidth = (btnWidthP - 5) / 2;
        this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 105, btnWidth, 20, (ITextComponent)new StringTextComponent("Cancel"), this::cancel_clicked));
        this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + 10 + btnWidth, this.top() + 105, btnWidth, 20, (ITextComponent)new StringTextComponent("Save"), this::save_clicked));
        this.updateConfirmState();
    }

    private void save_clicked(Button button) {
        AnimationProject.AnimationController controller = Animator.get().getProject().getAnimationControl();
        int len = SettingsDialog.parse(this.cycleField.func_146179_b(), controller.getAnimationTime());
        boolean repeat = this.onRepeat.func_212942_a();
        controller.setAnimationTime(len);
        controller.setOnRepeat(repeat);
        this.showParent();
    }

    private void cycleField_changed(String value) {
        if (this.cyclePattern.matcher(value).matches()) {
            this.cycleField.func_146193_g(0xE0E0E0);
            this.errored = false;
        } else {
            this.cycleField.func_146193_g(0xE00000);
            this.errored = true;
        }
        this.updateConfirmState();
    }

    private void setDefaultEasing_Clicked(Button button) {
        ChangeEasingDialog screen = new ChangeEasingDialog(this.getParent(), this::onEasingSelected);
        this.field_230706_i_.func_147108_a((Screen)screen);
    }

    private void onEasingSelected(IEasing easing) {
        AnimationProject project = Animator.get().getProject();
        AnimationProject.AnimationController controller = project.getAnimationControl();
        controller.setEasing(easing);
        this.easingButton.func_238482_a_(easing.getDisplayText());
    }

    private void updateConfirmState() {
        if (this.confirm != null) {
            this.confirm.field_230693_o_ = !this.errored;
        }
    }
}

